#include <amxmodx>
#include <amxmisc>
#include <fvault>

#define	MONTH_WITH_31_DAYS			(Month == 1 || Month == 3 || Month == 5 || Month == 7 || Month == 8 || Month == 10 || Month == 12)
#define	MONTH_WITH_30_DAYS			(Month == 4 || Month == 6 || Month == 9 || Month == 11)
#define	FEBRUARY				(Month == 2)

new const DataBase[] = "DATES"

new g_MsgSayText;

public plugin_init()
{
	register_plugin( "Automatically remove admin", "1.0", "Slifer" )
	
	register_dictionary( "RemoveAdmin.txt" )
	
	register_concmd( "amx_removeadmin","CmdRemoveAdmin", ADMIN_LEVEL_A, "<Name> <Day> <Month> <Year>" )
	
	g_MsgSayText = get_user_msgid( "SayText" )
}

public CmdRemoveAdmin( id, level, cid )
{
	if ( !cmd_access( id, level, cid, 3 ) )
		return PLUGIN_HANDLED;
		
	new szArg[32], szDays[32], szMonths[32], szYears[32]
	read_argv( 1, szArg, charsmax( szArg ) )
	read_argv( 2, szDays, charsmax( szDays ) )
	read_argv( 3, szMonths, charsmax( szMonths ) )
	read_argv( 4, szYears, charsmax( szYears ) )
	
	new Target = cmd_target( id, szArg, CMDTARGET_ALLOW_SELF | CMDTARGET_OBEY_IMMUNITY )
	
	if( !Target )
		return PLUGIN_HANDLED;
	
	new szAuthid[35];
	get_user_authid(id, szAuthid, charsmax(szAuthid) );
	
	new iStr = str_to_num(szDays)
	new mStr = str_to_num(szMonths)
	new yStr = str_to_num(szYears)
	
	new iDay[33], iMonth[33], iYear[33]
	get_time( "%d", iDay, charsmax(iDay) )
	get_time( "%m", iMonth, charsmax(iMonth) )
	get_time( "%y", iYear, charsmax(iYear) )
	
	new Day =  str_to_num( iDay )
	new Month = str_to_num( iMonth )
	new Year = str_to_num( iYear )
			
	if( MONTH_WITH_31_DAYS && iStr > 31 || MONTH_WITH_30_DAYS && iStr > 30 
	|| FEBRUARY && iStr > 28 || iStr <= 0 || mStr > 12 || mStr <= 0 
	|| ((iStr >= Day || iStr <= Day) && (mStr >= Month || mStr <= Month) && yStr < Year)
	|| (iStr <= Day && mStr <= Month && yStr < Year) || (iStr < Day && (mStr <= Month) && yStr <= Year) 
	|| (iStr > Day && (mStr <= Month) && yStr < Year) || yStr <= 0  || !isdigit(szDays[0]) || !isdigit( szMonths[0] ))
	{
		console_print( id, "%L", id, "DATE_NOT_FOUND" )
		return PLUGIN_HANDLED;
	}
		
	new iData[512]
	formatex( iData, charsmax(iData), "%i %i %i", iStr, mStr, yStr)
	fvault_set_data( DataBase, szAuthid, iData)
	
	console_print( id, "%L", id, "DATE_TO_REMOVE", szAuthid, iStr, mStr, yStr )
	
	return PLUGIN_CONTINUE;
}

public client_putinserver( id )
{
	set_task( 10.0, "CheckPlayerData", id )
}

public CheckPlayerData( id )
{
	new DayToRemove[33], MonthToRemove[33], YearToRemove[33]

	new szAuthid[35], Data[64];
	get_user_authid( id, szAuthid, charsmax(szAuthid) );
	
	new g_iDay[32], g_iMonth[33], g_iYear[33];
	get_time( "%d", g_iDay, charsmax(g_iDay) )
	get_time( "%m", g_iMonth, charsmax(g_iMonth) )
	get_time( "%y", g_iYear, charsmax(g_iYear) )
		
	new iMonth = str_to_num( g_iMonth )
	new iDay = str_to_num( g_iDay )
	new iYear = str_to_num( g_iYear )
	
	if( is_user_admin( id ) )
	{
		static g_Day[11], g_Month[11], g_Year[11]
	
		if( fvault_get_data( DataBase, szAuthid, Data, charsmax(Data) ) )
		{
			parse( Data, g_Day, 10, g_Month, 10, g_Year, 10 )
			
			DayToRemove[id] = str_to_num( g_Day )
			MonthToRemove[id] = str_to_num( g_Month )
			YearToRemove[id] = str_to_num( g_Year )
		
			if( iDay == DayToRemove[id] && iMonth == MonthToRemove[id] && iYear == YearToRemove[id] )
			{
				new szFile[64];
				get_configsdir(szFile, charsmax(szFile));
				add(szFile, charsmax(szFile), "/users.ini");
				
				new iFile = fopen(szFile, "rt");
				
				new szBuffer[128], szTemp[32], iLine;
				while(!feof(iFile))
				{
					fgets(iFile, szBuffer, charsmax(szBuffer));
					iLine++;
					
					if( !szBuffer[0] || szBuffer[0] == ';' )
						continue;
					
					parse(szBuffer, szTemp, charsmax(szTemp));
					remove_quotes(szTemp);
					
					if(equali(szTemp, szAuthid))
					{
						format(szBuffer, charsmax(szBuffer), ";%s", szBuffer);
						write_file(szFile, szBuffer, iLine - 1);
						break;
					}
				}
				fclose(iFile);
				
				ColorChat(id, "!g[A.R.A] %L",id, "ADMIN_EXPIRED", DayToRemove[id], MonthToRemove[id], YearToRemove[id] )
				return PLUGIN_HANDLED;
			}
			else
			{	
				ColorChat(id, "!g[A.R.A] %L", id, "DATE_TO_REMOVE_2", DayToRemove[id], MonthToRemove[id], YearToRemove[id]  )
				return PLUGIN_HANDLED;
			}
		}
	}
	
	return PLUGIN_HANDLED;
}


stock ColorChat(const id, const input[], any:...)
{
	new count = 1, players[32]
	static msg[191]
	vformat(msg, 190, input, 3)
	
	replace_all(msg, 190, "!g", "^4")
	replace_all(msg, 190, "!y", "^1")
	replace_all(msg, 190, "!team", "^3")
	replace_all(msg, 190, "!team2", "^0")
	
	if (id) players[0] = id; else get_players(players, count, "ch")
	{
		for (new i = 0; i < count; i++)
		{
			if (is_user_connected(players[i]))
			{
				message_begin(MSG_ONE_UNRELIABLE, g_MsgSayText, _, players[i])
				write_byte(players[i]);
				write_string(msg);
				message_end();
			}
		}
	}
}
